<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <?php echo $__env->make('public.components.meta-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Page Title -->
    <title>Agapi | Ultrassonografia e Medicina Fetal - Especialidades</title>
    <!-- Favicon Icon -->
    <?php echo $__env->make('public.components.favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('public.components.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<!-- Header Start -->
<?php echo $__env->make('public.components.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Header End -->

<!-- Page Header Section Start -->
<div class="page-header bg-section parallaxie">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-header-box">
                    <h1 class="text-anime-style-2" data-cursor="-opaque">Especialidades</h1>
                    <nav class="wow fadeInUp" data-wow-delay="0.25s">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item">/</li>
                            <li class="breadcrumb-item active" aria-current="page"><span>Especialidades</span></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page Header Section End -->

<!-- Page Services Section Start -->
<div class="page-services">
    <div class="container">
        <div class="row service-item-list">
            <div class="col-lg-4 col-md-6">
                <div class="service-item active wow fadeInUp">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-1.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom transvaginal ginecológico</a></h3>
                                <p>
                                    Avalia o útero e os ovários, assim como a presença de outras estruturas como massas,
                                    cistos e tumores pélvicos.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.2s">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-2.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom transvaginal de primeiro trimestre</a></h3>
                                <p>
                                    É o primeiro ultrassom da gestação e deve ser realizado preferencialmente após 7
                                    semanas, porque nesse momento já é possível visualizar embrião e batimentos
                                    cardíacos.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.4s">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-3.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom morfológico de 1º trimestre</a></h3>
                                <p>
                                    Deve ser realizado entre 11 semanas e 3 dias e 14 semanas, preferencialmente na 12ª
                                    semana, pelas vias abdominal e transvaginal.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.6s">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-4.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom morfológico de 2º trimestre</a></h3>
                                <p>
                                    Realizado preferencialmente entre 20 e 24 semanas de gestação, seu objetivo
                                    principal é avaliar a anatomia fetal de forma detalhada e detectar possíveis
                                    malformações.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.6s">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-4.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom obstétrico com doppler</a></h3>
                                <p>
                                    Exame realizado geralmente no 3º trimestre, avalia o crescimento e bem-estar fetal.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.6s">
                    <div class="service-image">
                        <img src="<?php echo e(asset('assets/images/service-1.jpg')); ?>" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-service-4.svg')); ?>" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom transvaginal para medida de colo uterino</a></h3>
                                <p>
                                    Tem por objetivo identificar pacientes com colo curto, sendo este um dos principais
                                    fatores de risco para parto prematuro. O melhor momento para se realizar essa medida
                                    é no segundo trimestre.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="section-footer-text wow fadeInUp" data-wow-delay="1s">
                    <p>
                        <span>[icone bebe]</span> Vamos agendar uma consulta? <a href="#">Clique aqui</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page Services Section End -->

<!-- Footer Start -->
<?php echo $__env->make('public.components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Footer End -->

<?php echo $__env->make('public.components.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH C:\htdocs\agapi-site\resources\views/public/specialty.blade.php ENDPATH**/ ?>