<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Clube Libertas - Benefícios</title>
    <!-- favicons Icons -->
    <?php echo $__env->make('public/components/favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Styles -->
    <?php echo $__env->make('public/components/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

<div class="page-wrapper">
    <header class="main-header clearfix">
        <?php echo $__env->make('public/components/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </header>

    <div class="stricky-header stricked-menu main-menu">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->

    <!--Page Header Start-->
    <section class="page-header">
        <div class="page-header-bg" style="background-image: url(assets/images/backgrounds/page-header-bg.jpg)">
        </div>
        <div class="container">
            <div class="page-header__inner">
                <ul class="thm-breadcrumb list-unstyled">
                    <li><a href="<?php echo e(url('/')); ?>">Home /</a></li>
                </ul>
                <h2>Benefícios</h2>
            </div>
        </div>
    </section>
    <!--Page Header End-->


    <!--Services Three Start-->
    <section class="services-three">
        <div class="services-three-shape"
             style="background-image: url(assets/images/shapes/services-three-shape.png)"></div>
        <div class="container">
            <div class="section-title text-center">
                <span class="section-title__tagline">Conheça</span>
                <p class="section-title__title-">No Clube Libertas você personaliza as coberturas e assistências da sua
                    proteção veicular. Veja abaixo todos os benefícios de ser um associado e tenha o seu veículo
                    protegido para curtir a vida numa boa.</p>
            </div>
            <div class="services-three__top">
                <div class="row">
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/rastreamento-de-localizacao-no-mapa.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Rastreamento 24h
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Acompanhe seu veículo 24h com rastreamento via computador ou celular e suporte de uma
                                central especializada.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/reboque-de-caminhao.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="mobile-application.html">
                                    Reboque
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Envio de reboque em caso de acidente ou pane do veículo, seja no âmbito mecânico ou
                                elétrico.
                            </p>
                            
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/taxi.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Táxi
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Em acidentes, incêndio ou furto a até 40 km de casa, o associado terá táxi para seu
                                endereço cadastrado.
                            </p>
                            
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/robusto.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Troca de Pneus
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Se danos aos pneus impedirem a locomoção, enviaremos um reboque até a
                                borracharia mais próxima, dentro do limite.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/mecanico-de-automoveis.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Socorro Elétrico / Mecânico
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Na hipótese de pane, que impossibilite a locomoção própria do veículo, o veículo será
                                rebocado, desde que não ultrapasse o limite contratado.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/bomba-de-gasolina-alt.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Pane Seca
                                </a>
                            </h3>
                            <p class="services-three__text">

                                Se o veículo parar por falta de combustível, a assistência enviará um reboque até o
                                posto mais próximo, dentro do limite contratado.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/chaveiro.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Chaveiro
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Após o conserto, se o atendimento ocorreu a mais de 100 km de casa, o veículo poderá ser
                                retirado pelo associado ou pessoa de confiança.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/construcao-de-casas.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Hospedagem
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Se atendido pela assistência, motorista e acompanhantes terão estadia em hotel, até R$
                                80 por pessoa, conforme a capacidade do veículo.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/treinador-de-usuario.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Proteção contra Furto/Roubo
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Em caso de furto ou roubo, a assistência registra no CNVR e oferece monitoramento e
                                rastreamento em tempo real.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/chama-de-fogo-curvada.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Proteção contra Incêndio
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Cobrimos o prejuízo de perda total sofrido pelo veículo, caso aconteça um acidente com
                                fogo ou incêndio.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/acidente-de-carro.svg')); ?>" width="60" height="60" alt="..." >

                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Proteção contra Colisão
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Em caso de colisão, fornecemos táxi para casa, primeiros socorros e remoção hospitalar
                                aos associados.
                            </p>
                            
                        </div>
                    </div>

                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services Three Single-->
                        <div class="services-three__single">
                            <div class="services-three_icon">
                                <img src="<?php echo e(asset('assets/images/icon/ban.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <h3 class="services-three__title">
                                <a href="#">
                                    Proteção contra Perda Total
                                </a>
                            </h3>
                            <p class="services-three__text">
                                Cobrimos prejuízos, exceto se condutor infringir leis de trânsito ou estiver sob efeito
                                de drogas.
                            </p>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Services Three End-->

    <!--Site Footer Start-->
    <?php echo $__env->make('public/components/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--Site Footer End-->

</div><!-- /.page-wrapper -->

<?php echo $__env->make('public/components/menu-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('public/components/scroll-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Scripts -->
<?php echo $__env->make('public/components/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH C:\htdocs\clube-libertas\resources\views/public/beneficios.blade.php ENDPATH**/ ?>