<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Clube Libertas - Contato</title>
    <!-- favicons Icons -->
    <?php echo $__env->make('public/components/favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Styles -->
    <?php echo $__env->make('public/components/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

<div class="page-wrapper">
    <header class="main-header clearfix">
        <?php echo $__env->make('public/components/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </header>

    <div class="stricky-header stricked-menu main-menu">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->

    <!--Page Header Start-->
    <section class="page-header">
        <div class="page-header-bg">
        </div>
        <div class="container">
            <div class="page-header__inner">
                <ul class="thm-breadcrumb list-unstyled">
                    <li><a href="<?php echo e(url('/')); ?>">Home /</a></li>
                </ul>
                <h2>Contato</h2>
            </div>
        </div>
    </section>
    <!--Page Header End-->

    <!--Location Start-->

    <!--Location End-->

    <!--contact Page Start-->
    <section class="contact-page">
        <div class="container">
            <div class="section-title" style="margin-bottom: 30px;">
                <span class="section-title__tagline">Fale Conosco</span>
                <h3>Tire todas as suas dúvidas ou envie suas sugestões para nossa
                    equipe.</h3>
            </div>
            <div class="row">
                <div class="col-xl-6">
                    <div class="contact-page__form">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success text-center mt-4">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('enviar.formulario.contato')); ?>" method="POST"
                              class="comment-one__form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-6 mt-4">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="Seu nome" name="name" value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger d-block"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-xl-6 mt-4">
                                    <div class="comment-form__input-box">
                                        <input type="email" placeholder="E-mail" name="email" value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger d-block"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-xl-6 mt-4">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="Telefone" id="phone" name="phone" value="<?php echo e(old('telefone')); ?>">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger d-block"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-xl-6 mt-4">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="Assunto" name="subject" value="<?php echo e(old('subject')); ?>">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger d-block"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-xl-12 mt-4">
                                    <div class="comment-form__input-box">
                                        <textarea name="message" placeholder="Digite sua mensagem"><?php echo e(old('message')); ?></textarea>
                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger d-block" style="margin-top: -15px;"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <button type="submit" class="thm-btn comment-form__btn">Enviar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 mt-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <!--Location Single-->
                            <div class="location__single">
                                <h3 class="location__title">Onde Estamos?</h3>
                                <p class="location__text">
                                    Av. Presidente Vargas, 504, Loja, Centro, Para de Minas - MG - CEP: 35.660-631
                                </p>
                            </div>

                            <!--Location Single-->
                            <div class="location__single location__single-last">
                                <h3 class="location__title">E-mail</h3>
                                <h5 class="location__phone-email">
                                    <a href="mailto:beneficios@clubelibertas.org" class="location__email">beneficios@clubelibertas.org</a>
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--contact Page End-->

    <!--Google Map Start-->
    <section class="contcat-page-google-map">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3752.359629137629!2d-44.603317022414146!3d-19.86703068864469!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0xa73b90ed339489%3A0xc22147a747e4e5c2!2sAv.%20Pres.%20Vargas%2C%20504%20-%20Vila%20Raquel%2C%20Par%C3%A1%20de%20Minas%20-%20MG%2C%2035661-000!5e0!3m2!1spt-BR!2sbr!4v1743975720560!5m2!1spt-BR!2sbr"
            class="contact-page-google-map__one" allowfullscreen></iframe>
    </section>
    <!--Google Map End-->

    <!--Site Footer Start-->
    <?php echo $__env->make('public/components/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--Site Footer End-->

</div><!-- /.page-wrapper -->

<?php echo $__env->make('public/components/menu-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('public/components/scroll-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Scripts -->
<?php echo $__env->make('public/components/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="<?php echo e(asset('assets/js/mask.js')); ?>"></script>

<!-- Google Recaptcha -->
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(config('services.recaptcha.v3_site_key')); ?>"></script>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo e(config('services.recaptcha.v3_site_key')); ?>', {action: 'submit'}).then(function(token) {
            if (document.querySelector('form')) {
                let form = document.querySelector('form');
                let input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'g-recaptcha-response';
                input.value = token;
                form.appendChild(input);
            }
        });
    });
</script>

</body>

</html>
<?php /**PATH C:\htdocs\clube-libertas\resources\views/public/contato.blade.php ENDPATH**/ ?>