<?php

namespace App\Services;

use Illuminate\Support\Facades\Mail;
use Illuminate\Mail\Message;
use Symfony\Component\Mime\Email;


class EmailService
{
    /**
     * Envia um e-mail com suporte para anexos.
     *
     * @param string $toEmail O endereço de e-mail do destinatário.
     * @param string $subject O assunto do e-mail.
     * @param string $view A view do e-mail (ex: 'emails.template').
     * @param array $data Os dados a serem passados para a view.
     * @param array|null $attachments Caminhos dos arquivos para anexar (opcional).
     * @return void
     * @throws \Exception Se ocorrer um erro ao enviar o e-mail.
     */
    public function sendEmail(string $toEmail, string $subject, string $view, array $data = [], array $attachments = null): void
    {
        try {
           Mail::send($view, $data, function (Message $message) use ($toEmail, $subject, $attachments) {
                if ($attachments && is_array($attachments)) {
                    foreach ($attachments as $attachment) {
                        if (is_string($attachment) && file_exists($attachment)) {
                            $message->attach($attachment);
                        }
                    }
                }
               $message->to($toEmail)->subject($subject);
            });
        } catch (\Exception $e) {
            \Log::error('Erro ao enviar e-mail: ' . $e->getMessage());
            throw new \Exception('Falha ao enviar o e-mail: ' . $e->getMessage());
        }
    }
}
