<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class NewsletterController extends Controller
{
    public function create(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:newsletters,email',
            'consent' => 'accepted',
        ],[
            'email.required' => 'O campo e-mail é obrigatório.',
            'consent.accepted' => 'Você precisa aceitar os termos e políticas.',
        ]);

        // Salvar email na base ou enviar notificação...
        /*Newsletter::create(['email' => $request->email]);*/

        return response()->json('ok', 200);
    }
}
